# Read input
A, B, s = [int(i) for i in input().split()]
d = int(input())

# First tackle the trivial case A = B = 0 in which case the recurrence would be degenerate.
if A == 0 and B == 0:
    print(0)
else:
    # Determine which element of F_n = AF_{n-1} + BF_{n-2} should be considered and the digit offset k from the back.
    # For this, note that every Fn takes up s + 1 digits in the expansion and F_1 = 1, F_2 = A with 0..0A the first F_n after the decimal (hence the +2)
    n = (d - 1) // (s + 1) + 2
    k = (s + 1) * (n - 1) - d
    # Direct formula has some troubles with float limits so we simply recurse.
    a = []
    a.append(0)
    a.append(1)
    a.append(A)
    for i in range(2,n):
        a.append(A * a[i] + B * a[i-1])
    num = a[-1]
    # Select kth digit
    print((num // (10 ** k)) % 10)
    
'''
    # Sad that this works (general formula for x/y), makes fibonacci observation useless
    y = 10 ** (2 * s + 2)
    y -= B
    y -= 10 ** (s + 1) * A
    ns = (10 * pow(10, d + 2 * s + 1, y) // y) % 10
    print(ns)
'''
    
